#delimit ;
clear;
set memory 1g;

/*
/*Purpose of this do file -- Figure out why the changes in the EPOP across groups seem to differ
between the reconcileBLS.dta and dataforlaborsupply.dta*/

use "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Organize Data\dataforlaborsupply.dta", replace;
drop if age==5;

drop if h_type==9 | ljcw==5 | ljcw==6;

preserve;
collapse employed, by(age edu sex year);

keep if year==1999 | year==2007;

sort year sex edu age;

outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\Table1unweighted.xls", replace;

restore; preserve;

collapse employed [pweight=marsupwt], by(age edu sex year);

keep if year==1999 | year==2007;

sort year sex edu age;

outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\Table1MarWeight.xls", replace;

restore; preserve;

collapse employed [pweight=a_fnlwgt], by(age edu sex year);

keep if year==1999 | year==2007;

sort year sex edu age;

outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\Table1BasicWeight.xls", replace;
*/

/*
/*========================================================*/
/* 081412 -- New version of 'unweighted' Table 1, also excluding
   the people with zero a_fnlwgt */
/*===========================================================*/

use "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Organize Data\dataforlaborsupply_noexclus.dta";

drop if age==5; /*Drop the oldest group*/
drop if a_lfsr==0; /*Drop members of the armed forces*/
drop if a_fnlwgt==0; /*Drop the people with zero basic CPS weight (i.e. the hispanic oversample)*/


collapse employed, by(age edu sex year);

keep if year==1999 | year==2007;

sort year sex edu age;

outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\Table1NoWeightNoZero.xls", replace;
*/

/*========================================================*/
/* Weighted version of Table 1, also excluding
   the people with zero a_fnlwgt */
/*===========================================================*/

use "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Organize Data\dataforlaborsupply_noexclus.dta";

recode edu (5=4);

drop if age==5; /*Drop the oldest group*/
drop if a_lfsr==0; /*Drop members of the armed forces*/
drop if a_fnlwgt==0; /*Drop the people with zero basic CPS weight (i.e. the hispanic oversample)*/


collapse employed [pweight=a_fnlwgt], by(age edu sex year);

keep if year==1999 | year==2007;

sort year sex edu age;

outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\Table1Wgts.xls", replace;
